*****************
*Set Parameters 
*****************
*set to data files that contains the factors
local Factors    = "../data/factors_BroadMOM (CNYadj BW36 20001_201310).xls"





***************************
*Import data
***************************
import excel using "`Factors'", firstrow sheet("Data and Forecasts") clear
drop if _n==1
outsheet using ../data/temp_files/temp.csv, replace nonames

insheet using ../data/temp_files/temp.csv, clear names
capture drop v*
capture drop cpi*

*normalize all variables to mean 0 variance 1
ds date, not
foreach v in `r(varlist)'{
	sum `v'
	gen `v'2 = (`v'-`r(mean)')/`r(sd)'
	drop `v'
	rename `v'2 `v'
}

*create correlation matrix of the 30 inputs
ds date, not
corr  `r(varlist)'


*drop obs that are after october 2013
drop if _n>=167

ds date, not
pca `r(varlist)'
predict pc1 pc2
screeplot


*generate a monthly date
gen month = substr(date,1,3)
replace month = subinstr(month,"/"," ",.)
gen year = substr(date,-4,4)

destring month year, replace
drop date
gen date = mdy(month, 1, year)
format date %td
drop if date==.

save ../data/temp_files/pc_manual.dta, replace



